/** 
 * A Java interface for the Stack ADT.
 * 
 * @param <T> The type of data that the stack stores.
 * 
 * @author Jadrian Miles
 */
public interface Stack<T> {
    /** Adds an item to the top of this stack. */
    public void push(T item);
    
    /** Removes the item from the top of this stack, and returns it.
     * @throws EmptyStackException if the stack is empty.
     */
    public T pop();
    
    /** Returns the item on top of the stack, without removing it.
     * @throws EmptyStackException if the stack is empty.
     */
    public T peek();
    
    /** Returns true if the stack is empty. */
    public boolean isEmpty();
    
    /** Removes all items from the stack. */
    public void clear();
    
    /** An exception to indicate that the stack is empty on pop or peek. */
    public static class EmptyStackException extends RuntimeException { }
}
