/**
 * A Java interface for the Priority Queue ADT.
 * 
 * Note that the relative priority of elements is defined by the compareTo()
 * method defined for the type of items stored in the queue.  In other words,
 * the priority of an item is equal to the value of the item.
 * 
 * See also PriorityPair and DefaultPriorityPairImplementation for the tools
 * that let you separate the priority of each entry from its value.
 * 
 * Note that this interface defines a *max* priority queue; the item with the
 * highest priority is what comes out of the queue.  The easiest way to get a
 * *min* priority queue is to separate priorities and values, and negate the
 * priorities that you use.
 * 
 * @param <T> the type of data the queue stores.
 * 
 * @author Jadrian Miles
 */
public interface PriorityQueue<T extends Comparable<? super T>> {
    /**
     * Adds an item to the queue.
     * @throws IllegalArgumentException if item is null.
     */
    public void add(T item);
    
    /** Removes the maximum item from the queue, and returns it.
     * @return null if the queue is empty.
     */
    public T remove();
    
    /** Returns the maximum item in the queue, without removing it.
     * @return null if the queue is empty.
     */
    public T peek();
    
    /** Returns true if the queue is empty. */
    public boolean isEmpty();
    
    /** Removes all items from the queue. */
    public void clear();
}
