/**
 * A utility interface for the Heap, Priority Queue, and Updatable Priority
 * Queue ADTs to work with an item and its priority simultaneously.
 * 
 * @param <T> the item type of the pair.
 * @param <P> the priority type.
 * 
 * @author Jadrian Miles
 */
public interface PriorityPair<T, P extends Comparable<? super P>>
        extends Comparable<PriorityPair<T, P>> {
    public T item();
    public P priority();
    
    // compareTo() is inherited fom the Comparable interface; PriorityPair
    // implementations must also implement this method.
    //public int compareTo(PriorityPair<T, P> rhs);
}

