/**
 * A default implementation of the PriorityPair interface, allowing priority-
 * based ADTs to work with an item and its priority simultaneously.
 * 
 * @param <T> the item type of the pair.
 * @param <P> the priority type.
 * 
 * @author Jadrian Miles
 */
public class
        DefaultPriorityPairImplementation<T, P extends Comparable<? super P>>
        implements PriorityPair<T, P> {
    private final T item;
    private final P priority;
    
    public DefaultPriorityPairImplementation(T item, P priority) {
        this.item = item;
        this.priority = priority;
    }
    
    public T item() {
       return this.item;
    }
    
    public P priority() {
        return this.priority;
    }
    
    public int compareTo(PriorityPair<T, P> rhs) {
        return this.priority.compareTo(rhs.priority());
    }
    
    public String toString() {
      return "<" + item + ", " + priority + ">";
    }
}
